//  Copyright (C) 2001  MandrakeSoft S.A.
//
//    MandrakeSoft S.A.
//    43, rue d'Aboukir
//    75002 Paris - France
//    http://www.linux-mandrake.com/
//    http://www.mandrakesoft.com/
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA





#define NEED_CPU_REG_SHORTCUTS 1
#include "bochs.h"
#include "assert.h"
#define LOG_THIS BX_CPU_THIS_PTR

#if BX_USE_CPU_SMF
#define this (BX_CPU(0))
#endif




  void
BX_CPU_C::write_virtual_checks(bx_segment_reg_t *seg, Bit32u offset,
                               unsigned length)
{
  Bit32u upper_limit;


  if ( protected_mode() ) {
    if ( seg->cache.valid==0 ) {
      BX_INFO(("seg = %s\n", BX_CPU_THIS_PTR strseg(seg)));
      BX_INFO(("seg->selector.value = %04x\n", (unsigned) seg->selector.value));
      BX_INFO(("write_virtual_checks: valid bit = 0\n"));
	  BX_INFO(("CS: %04x\n", (unsigned) BX_CPU_THIS_PTR sregs[1].selector.value));
	  BX_INFO(("IP: %04x\n", (unsigned) BX_CPU_THIS_PTR prev_eip));
      exception(BX_GP_EXCEPTION, 0, 0);
      return;
      }

    if (seg->cache.p == 0) { /* not present */
	  BX_INFO(("write_virtual_checks(): segment not present\n"));
      exception(int_number(seg), 0, 0);
      return;
      }

    switch ( seg->cache.type ) {
      case 0: case 1:   // read only
      case 4: case 5:   // read only, expand down
      case 8: case 9:   // execute only
      case 10: case 11: // execute/read
      case 12: case 13: // execute only, conforming
      case 14: case 15: // execute/read-only, conforming
		BX_INFO(("write_virtual_checks(): no write access to seg\n"));
        exception(int_number(seg), 0, 0);
        return;

      case 2: case 3: /* read/write */
        if ( (offset+length-1) > seg->cache.u.segment.limit_scaled ) {
		  BX_INFO(("write_virtual_checks(): write beyond limit, r/w\n"));
          exception(int_number(seg), 0, 0);
          return;
          }
        break;

      case 6: case 7: /* read write, expand down */
        if (seg->cache.u.segment.d_b)
          upper_limit = 0xffffffff;
        else
          upper_limit = 0x0000ffff;
        if ( (offset <= seg->cache.u.segment.limit_scaled) ||
             (offset > upper_limit) ||
             ((upper_limit - offset) < (length - 1)) ) {
		  BX_INFO(("write_virtual_checks(): write beyond limit, r/w ED\n"));
          exception(int_number(seg), 0, 0);
          return;
          }
        break;
      }

    return;
    }

  else { /* real mode */
    if ( (offset + length - 1)  >  seg->cache.u.segment.limit_scaled) {
      //BX_INFO(("write_virtual_checks() SEG EXCEPTION:  %x:%x + %x\n",
      //  (unsigned) seg->selector.value, (unsigned) offset, (unsigned) length));
      if (seg == & BX_CPU_THIS_PTR sregs[2]) exception(BX_SS_EXCEPTION, 0, 0);
      else exception(BX_GP_EXCEPTION, 0, 0);
      }
    }
}

  void
BX_CPU_C::read_virtual_checks(bx_segment_reg_t *seg, Bit32u offset,
                              unsigned length)
{
  Bit32u upper_limit;


  if ( protected_mode() ) {
    if ( seg->cache.valid==0 ) {
      BX_CPU_THIS_PTR info("seg = %s\n", BX_CPU_THIS_PTR strseg(seg));
      BX_CPU_THIS_PTR info("seg->selector.value = %04x\n", (unsigned) seg->selector.value);
      //BX_CPU_THIS_PTR info("read_virtual_checks: valid bit = 0\n");
      //BX_CPU_THIS_PTR info("CS: %04x\n", (unsigned)
      //BX_CPU_THIS_PTR sregs[1].selector.value);
      BX_INFO(("seg = %s\n", BX_CPU_THIS_PTR strseg(seg)));
      BX_INFO(("seg->selector.value = %04x\n", (unsigned) seg->selector.value));
      //BX_INFO(("read_virtual_checks: valid bit = 0\n"));
      //BX_INFO(("CS: %04x\n", (unsigned)
      //   BX_CPU_THIS_PTR sregs[1].selector.value));
      //BX_INFO(("IP: %04x\n", (unsigned) BX_CPU_THIS_PTR prev_eip));
      //debug(BX_CPU_THIS_PTR eip);
      exception(BX_GP_EXCEPTION, 0, 0);
      return;
      }

    if (seg->cache.p == 0) { /* not present */
	  BX_INFO(("read_virtual_checks(): segment not present\n"));
      exception(int_number(seg), 0, 0);
      return;
      }

    switch ( seg->cache.type ) {
      case 0: case 1: /* read only */
      case 10: case 11: /* execute/read */
      case 14: case 15: /* execute/read-only, conforming */
        if ( (offset+length-1) > seg->cache.u.segment.limit_scaled ) {
		  BX_INFO(("read_virtual_checks(): write beyond limit\n"));
          exception(int_number(seg), 0, 0);
          return;
          }
        break;

      case 2: case 3: /* read/write */
        if ( (offset+length-1) > seg->cache.u.segment.limit_scaled ) {
		  BX_INFO(("read_virtual_checks(): write beyond limit\n"));
          exception(int_number(seg), 0, 0);
          return;
          }
        break;

      case 4: case 5: /* read only, expand down */
        if (seg->cache.u.segment.d_b)
          upper_limit = 0xffffffff;
        else
          upper_limit = 0x0000ffff;
        if ( (offset <= seg->cache.u.segment.limit_scaled) ||
             (offset > upper_limit) ||
             ((upper_limit - offset) < (length - 1)) ) {
		  BX_INFO(("read_virtual_checks(): write beyond limit\n"));
          exception(int_number(seg), 0, 0);
          return;
          }
        break;

      case 6: case 7: /* read write, expand down */
        if (seg->cache.u.segment.d_b)
          upper_limit = 0xffffffff;
        else
          upper_limit = 0x0000ffff;
        if ( (offset <= seg->cache.u.segment.limit_scaled) ||
             (offset > upper_limit) ||
             ((upper_limit - offset) < (length - 1)) ) {
		  BX_INFO(("read_virtual_checks(): write beyond limit\n"));
          exception(int_number(seg), 0, 0);
          return;
          }
        break;

      case 8: case 9: /* execute only */
      case 12: case 13: /* execute only, conforming */
        /* can't read or write an execute-only segment */
		BX_INFO(("read_virtual_checks(): execute only\n"));
        exception(int_number(seg), 0, 0);
        return;
        break;
      }
    return;
    }

  else { /* real mode */
    if ( (offset + length - 1)  >  seg->cache.u.segment.limit_scaled) {
      //BX_CPU_THIS_PTR info("read_virtual_checks() SEG EXCEPTION:  %x:%x + %x\n",
      //  (unsigned) seg->selector.value, (unsigned) offset, (unsigned) length);
      if (seg == & BX_CPU_THIS_PTR sregs[2]) exception(BX_SS_EXCEPTION, 0, 0);
      else exception(BX_GP_EXCEPTION, 0, 0);
      }
    return;
    }
}




  char *
BX_CPU_C::strseg(bx_segment_reg_t *seg)
{
  if (seg == &BX_CPU_THIS_PTR sregs[0]) return("ES");
  else if (seg == & BX_CPU_THIS_PTR sregs[1]) return("CS");
  else if (seg == & BX_CPU_THIS_PTR sregs[2]) return("SS");
  else if (seg == &BX_CPU_THIS_PTR sregs[3]) return("DS");
  else if (seg == &BX_CPU_THIS_PTR sregs[4]) return("FS");
  else if (seg == &BX_CPU_THIS_PTR sregs[5]) return("GS");
  else {
    BX_INFO(("undefined segment passed to strseg()!\n"));
    return("??");
    }
}




  void
BX_CPU_C::write_virtual_byte(unsigned s, Bit32u offset, Bit8u *data)
{
  Bit32u laddr;
  bx_segment_reg_t *seg;
  Bit8u *p;

  seg = &BX_CPU_THIS_PTR sregs[s];

  if((p=BX_CPU_THIS_PTR sregs_map[s].scanmap(this,seg,offset,1,true))!=NULL) {
    *p=*data;
    return;
  }

  write_virtual_checks(seg, offset, 1);

  laddr = seg->cache.u.segment.base + offset;
  BX_INSTR_MEM_DATA(laddr, 1, BX_WRITE);

  // all checks OK
  access_linear(laddr, 1, CPL==3, BX_WRITE, (void *) data);
}

  void
BX_CPU_C::write_virtual_word(unsigned s, Bit32u offset, Bit16u *data)
{
  Bit32u laddr;
  bx_segment_reg_t *seg;
  Bit8u *p;

  seg = &BX_CPU_THIS_PTR sregs[s];

  if((p=BX_CPU_THIS_PTR sregs_map[s].scanmap(this,seg,offset,2,true))!=NULL) {
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
    *p=*data;
    *(p+1)=(*data)>>8;
#else
    *((Bit16u*)p)=*data;
#endif
    return;
  }

  write_virtual_checks(seg, offset, 2);

  laddr = seg->cache.u.segment.base + offset;
  BX_INSTR_MEM_DATA(laddr, 2, BX_WRITE);

  // all checks OK
  access_linear(laddr, 2, CPL==3, BX_WRITE, (void *) data);
}

  void
BX_CPU_C::write_virtual_dword(unsigned s, Bit32u offset, Bit32u *data)
{
  Bit32u laddr;
  bx_segment_reg_t *seg;
  Bit8u *p;

  seg = &BX_CPU_THIS_PTR sregs[s];

  if((p=BX_CPU_THIS_PTR sregs_map[s].scanmap(this,seg,offset,4,true))!=NULL) {
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
    *p=*data;
    *(p+1)=(*data)>>8;
    *(p+2)=(*data)>>16;
    *(p+3)=(*data)>>24;
#else
    *((Bit32u*)p)=*data;
#endif
    return;
  }

  write_virtual_checks(seg, offset, 4);

  laddr = seg->cache.u.segment.base + offset;
  BX_INSTR_MEM_DATA(laddr, 4, BX_WRITE);

  // all checks OK
  access_linear(laddr, 4, CPL==3, BX_WRITE, (void *) data);
}

  void
BX_CPU_C::read_virtual_byte(unsigned s, Bit32u offset, Bit8u *data)
{
  Bit32u laddr;
  bx_segment_reg_t *seg;
  Bit8u *p;

  seg = &BX_CPU_THIS_PTR sregs[s];

  if((p=BX_CPU_THIS_PTR sregs_map[s].scanmap(this,seg,offset,1,false))!=NULL) {
    *data=*p;
    return;
  }

  read_virtual_checks(seg, offset, 1);

  laddr = seg->cache.u.segment.base + offset;
  BX_INSTR_MEM_DATA(laddr, 1, BX_READ);

  // all checks OK
  access_linear(laddr, 1, CPL==3, BX_READ, (void *) data);
}


  void
BX_CPU_C::read_virtual_word(unsigned s, Bit32u offset, Bit16u *data)
{
  Bit32u laddr;
  bx_segment_reg_t *seg;
  Bit8u *p;

  seg = &BX_CPU_THIS_PTR sregs[s];

  if((p=BX_CPU_THIS_PTR sregs_map[s].scanmap(this,seg,offset,2,false))!=NULL) {
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
    Bit16u work;
    work=*p;
    work|=(*(p+1))<<8;
    *data=work;
#else
    *data=*((Bit16u*)p);
#endif
    return;
  }

  read_virtual_checks(seg, offset, 2);

  laddr = seg->cache.u.segment.base + offset;
  BX_INSTR_MEM_DATA(laddr, 2, BX_READ);

  // all checks OK
  access_linear(laddr, 2, CPL==3, BX_READ, (void *) data);
}


  void
BX_CPU_C::read_virtual_dword(unsigned s, Bit32u offset, Bit32u *data)
{
  Bit32u laddr;
  bx_segment_reg_t *seg;
  Bit8u *p;

  seg = &BX_CPU_THIS_PTR sregs[s];

  if((p=BX_CPU_THIS_PTR sregs_map[s].scanmap(this,seg,offset,4,false))!=NULL) {
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
    Bit32u work;
    work=*p;
    work|=(*(p+1))<<8;
    work|=(*(p+2))<<16;
    work|=(*(p+3))<<24;
    *data=work;
#else
    *data=*((Bit32u*)p);
#endif
    return;
  }

  read_virtual_checks(seg, offset, 4);

  laddr = seg->cache.u.segment.base + offset;
  BX_INSTR_MEM_DATA(laddr, 4, BX_READ);

  // all checks OK
  access_linear(laddr, 4, CPL==3, BX_READ, (void *) data);
}

//////////////////////////////////////////////////////////////
// special Read-Modify-Write operations                     //
// address translation info is kept across read/write calls //
//////////////////////////////////////////////////////////////

  void
BX_CPU_C::read_RMW_virtual_byte(unsigned s, Bit32u offset, Bit8u *data)
{
  Bit32u laddr;
  bx_segment_reg_t *seg;

  seg = &BX_CPU_THIS_PTR sregs[s];

#if BX_SEGMAP
  if((BX_CPU_THIS_PTR address_xlation.direct_p =
      BX_CPU_THIS_PTR sregs_map[s].scanmap(this,seg,offset,1,true))!=NULL) {
    *data=*(BX_CPU_THIS_PTR address_xlation.direct_p);
    return;
  }
#endif

  write_virtual_checks(seg, offset, 1);

  laddr = seg->cache.u.segment.base + offset;
  BX_INSTR_MEM_DATA(laddr, 1, BX_READ);

  // all checks OK
#if BX_CPU_LEVEL >= 3
  if (BX_CPU_THIS_PTR cr0.pg)
    access_linear(laddr, 1, CPL==3, BX_RW, (void *) data);
  else
#endif
    {
    BX_CPU_THIS_PTR address_xlation.paddress1 = laddr;
    BX_INSTR_LIN_READ(laddr, laddr, 1);
    BX_INSTR_LIN_WRITE(laddr, laddr, 1);
    BX_CPU_THIS_PTR mem->read_physical(this, laddr, 1, (void *) data);
    }
}


  void
BX_CPU_C::read_RMW_virtual_word(unsigned s, Bit32u offset, Bit16u *data)
{
  Bit32u laddr;
  bx_segment_reg_t *seg;

  seg = &BX_CPU_THIS_PTR sregs[s];

#if BX_SEGMAP
  if((BX_CPU_THIS_PTR address_xlation.direct_p =
      BX_CPU_THIS_PTR sregs_map[s].scanmap(this,seg,offset,2,true))!=NULL) {
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
    Bit16u work;
    work=*(BX_CPU_THIS_PTR address_xlation.direct_p);
    work|=(*(BX_CPU_THIS_PTR address_xlation.direct_p+1))<<8;
    *data=work;
#else
    *data=*((Bit16u*)(BX_CPU_THIS_PTR address_xlation.direct_p));
#endif
    return;
  }
#endif

  write_virtual_checks(seg, offset, 2);

  laddr = seg->cache.u.segment.base + offset;
  BX_INSTR_MEM_DATA(laddr, 2, BX_READ);

  // all checks OK
#if BX_CPU_LEVEL >= 3
  if (BX_CPU_THIS_PTR cr0.pg)
    access_linear(laddr, 2, CPL==3, BX_RW, (void *) data);
  else
#endif
    {
    BX_CPU_THIS_PTR address_xlation.paddress1 = laddr;
    BX_INSTR_LIN_READ(laddr, laddr, 2);
    BX_INSTR_LIN_WRITE(laddr, laddr, 2);
    BX_CPU_THIS_PTR mem->read_physical(this, laddr, 2, data);
    }
}

  void
BX_CPU_C::read_RMW_virtual_dword(unsigned s, Bit32u offset, Bit32u *data)
{
  Bit32u laddr;
  bx_segment_reg_t *seg;

  seg = &BX_CPU_THIS_PTR sregs[s];

#if BX_SEGMAP
  if((BX_CPU_THIS_PTR address_xlation.direct_p =
      BX_CPU_THIS_PTR sregs_map[s].scanmap(this,seg,offset,4,true))!=NULL) {
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
    Bit32u work;
    work=*(BX_CPU_THIS_PTR address_xlation.direct_p);
    work|=(*(BX_CPU_THIS_PTR address_xlation.direct_p+1))<<8;
    work|=(*(BX_CPU_THIS_PTR address_xlation.direct_p+2))<<16;
    work|=(*(BX_CPU_THIS_PTR address_xlation.direct_p+3))<<24;
    *data=work;
#else
    *data=*((Bit32u*)(BX_CPU_THIS_PTR address_xlation.direct_p));
#endif
    return;
  }
#endif

  write_virtual_checks(seg, offset, 4);

  laddr = seg->cache.u.segment.base + offset;
  BX_INSTR_MEM_DATA(laddr, 4, BX_READ);

  // all checks OK
#if BX_CPU_LEVEL >= 3
  if (BX_CPU_THIS_PTR cr0.pg)
    access_linear(laddr, 4, CPL==3, BX_RW, (void *) data);
  else
#endif
    {
    BX_CPU_THIS_PTR address_xlation.paddress1 = laddr;
    BX_INSTR_LIN_READ(laddr, laddr, 4);
    BX_INSTR_LIN_WRITE(laddr, laddr, 4);
    BX_CPU_THIS_PTR mem->read_physical(this, laddr, 4, data);
    }
}

  void
BX_CPU_C::write_RMW_virtual_byte(Bit8u val8)
{
#if BX_SEGMAP
  if(BX_CPU_THIS_PTR address_xlation.direct_p !=NULL) {
    *(BX_CPU_THIS_PTR address_xlation.direct_p)=val8;
    return;
  }
#endif

  BX_INSTR_MEM_DATA(BX_CPU_THIS_PTR address_xlation.paddress1, 1, BX_WRITE);

#if BX_CPU_LEVEL >= 3
  if (BX_CPU_THIS_PTR cr0.pg) {
    // BX_CPU_THIS_PTR address_xlation.pages must be 1
    BX_CPU_THIS_PTR mem->write_physical(this, BX_CPU_THIS_PTR address_xlation.paddress1, 1, &val8);
    }
  else
#endif
    {
    BX_CPU_THIS_PTR mem->write_physical(this, BX_CPU_THIS_PTR address_xlation.paddress1, 1, &val8);
    }
}

  void
BX_CPU_C::write_RMW_virtual_word(Bit16u val16)
{
#if BX_SEGMAP
  if(BX_CPU_THIS_PTR address_xlation.direct_p !=NULL) {
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
    *(BX_CPU_THIS_PTR address_xlation.direct_p)=val16;
    *(BX_CPU_THIS_PTR address_xlation.direct_p+1)=val16>>8;
#else
    *((Bit16u*)(BX_CPU_THIS_PTR address_xlation.direct_p))=val16;
#endif
    return;
  }
#endif

  BX_INSTR_MEM_DATA(BX_CPU_THIS_PTR address_xlation.paddress1, 2, BX_WRITE);

#if BX_CPU_LEVEL >= 3
  if (BX_CPU_THIS_PTR cr0.pg) {
    if (BX_CPU_THIS_PTR address_xlation.pages == 1) {
      BX_CPU_THIS_PTR mem->write_physical(this, BX_CPU_THIS_PTR address_xlation.paddress1, 2, &val16);
      }
    else {
#ifdef BX_LITTLE_ENDIAN
      BX_CPU_THIS_PTR mem->write_physical(this, BX_CPU_THIS_PTR address_xlation.paddress1, 1,
                            &val16);
      BX_CPU_THIS_PTR mem->write_physical(this, BX_CPU_THIS_PTR address_xlation.paddress2, 1,
                            ((Bit8u *) &val16) + 1);
#else
      BX_CPU_THIS_PTR mem->write_physical(this, BX_CPU_THIS_PTR address_xlation.paddress1, 1,
                            ((Bit8u *) &val16) + 1);
      BX_CPU_THIS_PTR mem->write_physical(this, BX_CPU_THIS_PTR address_xlation.paddress2, 1,
                            &val16);
#endif
      }
    }
  else
#endif
    {
    BX_CPU_THIS_PTR mem->write_physical(this, BX_CPU_THIS_PTR address_xlation.paddress1, 2, &val16);
    }
}

  void
BX_CPU_C::write_RMW_virtual_dword(Bit32u val32)
{
#if BX_SEGMAP
  if(BX_CPU_THIS_PTR address_xlation.direct_p !=NULL) {
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
    *(BX_CPU_THIS_PTR address_xlation.direct_p)=val32;
    *(BX_CPU_THIS_PTR address_xlation.direct_p+1)=val32>>8;
    *(BX_CPU_THIS_PTR address_xlation.direct_p+2)=val32>>16;
    *(BX_CPU_THIS_PTR address_xlation.direct_p+3)=val32>>24;
#else
    *((Bit32u*)(BX_CPU_THIS_PTR address_xlation.direct_p))=val32;
#endif
    return;
  }
#endif

  BX_INSTR_MEM_DATA(BX_CPU_THIS_PTR address_xlation.paddress1, 4, BX_WRITE);

#if BX_CPU_LEVEL >= 3
  if (BX_CPU_THIS_PTR cr0.pg) {
    if (BX_CPU_THIS_PTR address_xlation.pages == 1) {
      BX_CPU_THIS_PTR mem->write_physical(this, BX_CPU_THIS_PTR address_xlation.paddress1, 4, &val32);
      }
    else {
#ifdef BX_LITTLE_ENDIAN
      BX_CPU_THIS_PTR mem->write_physical(this, BX_CPU_THIS_PTR address_xlation.paddress1,
                            BX_CPU_THIS_PTR address_xlation.len1,
                            &val32);
      BX_CPU_THIS_PTR mem->write_physical(this, BX_CPU_THIS_PTR address_xlation.paddress2,
                            BX_CPU_THIS_PTR address_xlation.len2,
                            ((Bit8u *) &val32) + BX_CPU_THIS_PTR address_xlation.len1);
#else
      BX_CPU_THIS_PTR mem->write_physical(this, BX_CPU_THIS_PTR address_xlation.paddress1,
                            BX_CPU_THIS_PTR address_xlation.len1,
                            ((Bit8u *) &val32) + (4 - BX_CPU_THIS_PTR address_xlation.len1));
      BX_CPU_THIS_PTR mem->write_physical(this, BX_CPU_THIS_PTR address_xlation.paddress2,
                            BX_CPU_THIS_PTR address_xlation.len2,
                            &val32);
#endif
      }
    }
  else
#endif
    {
    BX_CPU_THIS_PTR mem->write_physical(this, BX_CPU_THIS_PTR address_xlation.paddress1, 4, &val32);
    }
}


#if BX_EMULATION_TOWNS
  void
BX_CPU_C::block_copy_virtual(vaddrinfo dest,
			     vaddrinfo src,
			     unsigned pl,
			     Bit32u len,
			     Boolean is32)
{
  Bit32u clen;
  laddrinfo dest2,src2;
  bx_segment_reg_t srcseg,destseg;

  BX_INFO(("block_copy_virtual: pl=%d, len=0x%.8x, is32=%d.\n",pl,len,is32));
  if(src.vmem) {
    BX_INFO(("block_copy_virtual: src=(0x%.4x:0x%.8x).\n",src.a.v.s,src.a.v.o));
  } else {
    BX_INFO(("block_copy_virtual: src=[%p]\n",src.a.p));
  }
  if(dest.vmem) {
    BX_INFO(("block_copy_virtual: dest=(0x%.4x:0x%.8x).\n",dest.a.v.s,dest.a.v.o));
  } else {
    BX_INFO(("block_copy_virtual: dest=[%p]\n",dest.a.p));
  }

  while(len > 0) {
    clen = len;

    if(src.vmem) {
      if(is32) {
	if(0xffffffff - src.a.v.o + 1 < clen && src.a.v.o != 0) {
	  clen = 0xffffffff - src.a.v.o + 1;
	}
      } else {
	if(0xffff - src.a.v.o + 1 < clen) {
	  clen = 0xffff - src.a.v.o + 1;
	}
      }
      src2.vmem = 1;
      if ( protected_mode() ) {
	load_seg_reg(&srcseg,src.a.v.s);
 	read_virtual_checks(&srcseg,src.a.v.o,1);
	read_virtual_checks(&srcseg,src.a.v.o+clen-1,1);
	src2.a.l = srcseg.cache.u.segment.base + src.a.v.o;
      } else {
	src2.a.l = src.a.v.s * 16 + src.a.v.o;
      }
    } else {
      src2.vmem = 0;
      src2.a.p = src.a.p;
    }

    if(dest.vmem) {
      if(is32) {
	if(0xffffffff - dest.a.v.o + 1 < clen && dest.a.v.o != 0) {
	  clen = 0xffffffff - dest.a.v.o + 1;
	}
      } else {
	if(0xffff - dest.a.v.o + 1 < clen) {
	  clen = 0xffff - dest.a.v.o + 1;
	}
      }
      dest2.vmem = 1;
      if ( protected_mode() ) {
	load_seg_reg(&destseg,dest.a.v.s);
 	write_virtual_checks(&destseg,dest.a.v.o,1);
	write_virtual_checks(&destseg,dest.a.v.o+clen-1,1);
	dest2.a.l = destseg.cache.u.segment.base + dest.a.v.o;
      } else {
	dest2.a.l = dest.a.v.s * 16 + dest.a.v.o;
      }
    } else {
      dest2.vmem = 0;
      dest2.a.p = dest.a.p;
    }

    block_copy_linear(dest2,src2,pl,clen);

    len -= clen;
    if(src.vmem) {
      src.a.v.o += clen;
    } else {
      src.a.p = ((Bit8u*)(src.a.p)) + clen;
    }
    if(dest.vmem) {
      dest.a.v.o += clen;
    } else {
      dest.a.p = ((Bit8u*)(dest.a.p)) + clen;
    }
  }
}
#endif

#if BX_SEGMAP
#undef LOG_THIS
#undef this
#undef BX_CPU_THIS_PTR
#undef BX_SMF
#undef BX_CPU_C_PREFIX
#undef BX_CPU_CALL_METHOD

Bit8u *bx_segment_addrmap_t::genmap_seg(BX_CPU_C *cpu,
					bx_segment_reg_t *seg,
					Bit32u offset,
					unsigned size,
					Boolean write)
{
  Bit32u min,max;
  Bit32u linear;
  Bit8u *p;

  min=offset&0xfffff000;
  max=offset|0x00000fff;

  /* min <= offset <= max */

  if ( cpu->protected_mode() ) {
    if ( seg->cache.valid==0 ) {
      return NULL;
    }

    if (seg->cache.p == 0) { /* not present */
      return NULL;
    }

    switch ( seg->cache.type ) {
      case 0: case 1: /* read only */
      case 10: case 11: /* execute/read */
      case 14: case 15: /* execute/read-only, conforming */
	if(write) return NULL;
      case 2: case 3: /* read/write */
        if ( max > seg->cache.u.segment.limit_scaled )
	  max = seg->cache.u.segment.limit_scaled;
        break;

      case 4: case 5: /* read only, expand down */
	if(write) return NULL;
      case 6: case 7: /* read write, expand down */
        if (!seg->cache.u.segment.d_b)
	  if ( max > 0x0000ffff ) max = 0x0000ffff;
        if ( min <= seg->cache.u.segment.limit_scaled)
	  min = seg->cache.u.segment.limit_scaled;
        break;

      case 8: case 9: /* execute only */
      case 12: case 13: /* execute only, conforming */
	return NULL;
      }
    }

  else { /* real mode */
    if ( max > seg->cache.u.segment.limit_scaled )
      max = seg->cache.u.segment.limit_scaled;
    }

  /* check order min <= offset <= max */
  if(min>offset) return NULL;
  if(offset>max) return NULL;

  /* assume order min <= offset <= max */
  if(min+seg->cache.u.segment.base<min) {
    /* min, offset and max is overflow */
    min+=seg->cache.u.segment.base;
    linear=offset+seg->cache.u.segment.base;
    max+=seg->cache.u.segment.base;
  } else {
    if(offset+seg->cache.u.segment.base<offset) {
      /* offset and max is overflow */
      min=0x00000000;
      linear=offset+seg->cache.u.segment.base;
      max+=seg->cache.u.segment.base;
    } else {
      /* max is only overflow */
      if(max+seg->cache.u.segment.base<max) {
	min+=seg->cache.u.segment.base;
	linear=offset+seg->cache.u.segment.base;
	max+=0xffffffff;
      } else {
	/* not overflow */
	min+=seg->cache.u.segment.base;
	linear=offset+seg->cache.u.segment.base;
	max+=seg->cache.u.segment.base;
      }
    }
  }

  assert(min<=linear);
  assert(linear<=max);

  if((p=genmap_page(cpu,seg->selector.rpl==3,linear,&max,&min,write))==NULL) return NULL;
  min-=seg->cache.u.segment.base;
  max-=seg->cache.u.segment.base;

  assert(min<=offset);
  assert(offset<=max);

  if(max<3) return NULL;
  map_data *m=&map[(offset>>12)%MAPSIZE][write ? 0 : 1];
  m->p[(min&0x00000fff)==0 ? 0 : 1]=p-offset;
  m->min[(min&0x00000fff)==0 ? 0 : 1]=min;
  m->max1[(min&0x00000fff)==0 ? 0 : 1]=max;
  m->max2[(min&0x00000fff)==0 ? 0 : 1]=max-1;
  m->max4[(min&0x00000fff)==0 ? 0 : 1]=max-3;
  m->count[(min&0x00000fff)==0 ? 0 : 1]=count;
  if(offset+size-1>max) return NULL;
  return p;
}

void bx_segment_addrmap_t::clear(void)
{
  int i;

  for(i=0;i<MAPSIZE;i++) {
    // invalidation sentinel
    map[i][0].count[0]=map[i][0].count[1]
      =map[i][1].count[0]=map[i][1].count[1]=MAXCOUNT+1;
  }
  count=0;
}
#endif
